%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% (c) 2001-2002, Marcin Kasperski <Marcin.Kasperski@acn.waw.pl>
% $Id: mkofficial.cls,v 1.3 2002/04/11 23:34:20 marcink Exp $
%
% Prba nadania dokumentowi LaTeXowemu wygldu odbieranego jako
% 'profesjonalny' w zastosowaniach biurowo-projektowych. 
% Adaptuje standardowy styl 'report' podmieniajc wygld strony
% tytuowej i preambuy i modyfikujc niektre elementy formatu.
% Ustawia te rozmaite 'poloniki'. 
%
% Klasa stanowi raczej przykad konkretnego zastosowania (do 
% ewentualnych modyfikacji) ni szablon do dostosowywania przy
% pomocy parametrw - choby dlatego, e samodzielnie ustala
% rozmiar czcionki, wybiera fonty etc.
%
% Wykorzystanie - patrz przyklad.tex
%
% Strona domowa: http://www.kasperski.prv.pl/porady/porady_latex
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Identyfikacja
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{mkofficial}[2002/03/16 Oficjalny papierek (MK)]

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Opcje
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%\DeclareOption{draft}{\setlength{\overfullrule}{5pt}}

% Wszystkie nieznane opcje przekazujemy do report
\DeclareOption{landscape}{\OptionNotUsed}
\DeclareOption*{%
  \PassOptionsToClass{\CurrentOption}{report}%
}

% Wykonanie opcji
\ProcessOptions\relax

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Zaadowanie bazowej klasy i pakietw
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\LoadClass[a4paper,openright,12pt]{report}

% Mwimy po polsku
\RequirePackage{polski}
% Troch mniejsze marginesy
\RequirePackage{geometry}
% Domyln czcionk bdzie QuasiTimes
\RequirePackage{qtimes}
% Do tytuowania uyjemy QuasiPalladio
\renewcommand{\sfdefault}{qpl}
% Do tekstw maszynowych jak znalaz jest QuasiCourier
\renewcommand{\ttdefault}{qcr}
% Stosujemy specyficzne nagwki stron
\RequirePackage{fancyhdr}
% Wykorzystujemy 'swka' RCS/CVS do pobierania info o numerze wersji
\RequirePackage{rcs}
% Tabelki (uywane w preambule, czsto przydatne w dokumencie)
\RequirePackage{hhline}
\RequirePackage{tabularx}
% Standardowo generujemy PDFy, warto by byy 'hiperczne'
\RequirePackage{hyperref}
% Przyda si do logo a i czsto w dokumencie
\RequirePackage{graphicx}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Formatowanie akapitw (brak wcicia, odstpy midzy)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\setlength{\parindent}{0pt}

%\setlength{\parskip}{\partopsep}
\setlength{\parskip}{\medskipamount}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Cianiejsze odstpy midzy elementami list
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\setlength\partopsep{3\p@ \@plus 2\p@ \@minus 2\p@}
\def\@listi{\leftmargin\leftmargini
            \parsep 3\p@  \@plus1.5\p@ \@minus\p@ % Byo 5 + 2.5 - 1
            \topsep 5\p@ \@plus2\p@   \@minus3\p@ % BYo 10 + 4 - 6
            \itemsep2.5\p@  \@plus1.5\p@ \@minus\p@} % Byo 5 + 2.5 - 1
\let\@listI\@listi
\@listi
\def\@listii {\leftmargin\leftmarginii
              \labelwidth\leftmarginii
              \advance\labelwidth-\labelsep
              \topsep    2.5\p@   \@plus1.5\p@ \@minus\p@ % Byo 5 + 2.5 - 1
              \parsep    2\p@ \@plus\p@    \@minus\p@ % BYo 2.5 + 1 - 1
              \itemsep   \parsep}
\def\@listiii{\leftmargin\leftmarginiii
              \labelwidth\leftmarginiii
              \advance\labelwidth-\labelsep
              \topsep    2\p@\@plus\p@\@minus\p@ % BYo 2.5 + 1 - 1
              \parsep    \z@
              \partopsep \p@ \@plus\z@ \@minus\p@ % Bylo 1 + 0 - 1
              \itemsep   \topsep}
\def\@listiv {\leftmargin\leftmarginiv
              \labelwidth\leftmarginiv
              \advance\labelwidth-\labelsep}
\def\@listv  {\leftmargin\leftmarginv
              \labelwidth\leftmarginv
              \advance\labelwidth-\labelsep}
\def\@listvi {\leftmargin\leftmarginvi
              \labelwidth\leftmarginvi
              \advance\labelwidth-\labelsep}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Korekty znaczenia znakw
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Znak podkrelenia jest zwyk liter - matematyka zazwyczaj nie 
% wystpuje
\catcode`\_=11

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Zmienne redefiniowane przez standardowe polecenia
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Zmienna zawierajca podtytu
\newcommand{\@subtitle}{Podtytu\ClassWarning{mkofficial}{Brak \noexpand\subtitle}}
% Zmienna zawierajca opis
\newcommand{\@info}{Tajemniczy opis dokumentu\ClassWarning{mkofficial}{Brak \noexpand\info}}
% Zmienna zawierajaca status
\newcommand{\@status}{roboczy}
% Data utworzenia
\newcommand{\@creationDate}{1970-01-01\ClassWarning{mkofficial}{Brak \noexpand\creationDate}}
% Projekt
\newcommand{\@project}{Wielki projekt\ClassWarning{mkofficial}{Brak \noexpand\project}}

% Komenda ustalajca podtytu
\DeclareRobustCommand{\subtitle}[1]{%
  \renewcommand{\@subtitle}{#1}%
  }
% Komenda ustalajca tekst informacyjny
\DeclareRobustCommand{\info}[1]{%
  \renewcommand{\@info}{#1}%
  }
% Komenda ustalajca dat utworzenia
\DeclareRobustCommand{\creationDate}[1]{%
  \renewcommand{\@creationDate}{#1}%
  }
% Ustalenie projektu
\DeclareRobustCommand{\project}[1]{%
  \renewcommand{\@project}{#1}%
  }

% Predefiniowana komenda na info o firmie
\newcommand{\@organizationInfo}{%
  \ClassWarning{mkofficial}{Brak \noexpand\organizationInfo}%
  Przydaby si adres firmy...}
\DeclareRobustCommand{\organizationInfo}[1]{%
  \renewcommand{\@organizationInfo}{#1}%
  }

\newcommand{\@logo}{%
  \ClassWarning{mkofficial}{Brak \noexpand\logo}%
  \fbox{Tu by niele wygldao logo firmy.}%
}
\DeclareRobustCommand{\logo}[1]{%
  \renewcommand{\@logo}{#1}%
  }

% To skasuje 'Rozdzia' z headera
\renewcommand\@chapapp{}

% Stopki na stronach tytuowych
\fancypagestyle{plain}{
  \fancyhead{}%
  \renewcommand{\headrulewidth}{0pt}%
  \fancyfoot{}%
  \renewcommand{\footrulewidth}{0.4pt}%
  \if@twoside%
    \fancyfoot[LE,RO]{\thepage}%
    \fancyfoot[RE]{\footnotesize\MakeUppercase\@title}%
    \fancyfoot[LO]{\footnotesize{\@organizationInfo}}%
  \else%
    \fancyfoot[L]{\footnotesize{\@organizationInfo}}%
    \fancyfoot[R]{\thepage}%
  \fi%
}
% Nagwki i stopki na pozostaych stronach. 
\fancypagestyle{thebody}{%
  \fancyhead{}%
  \renewcommand{\headrulewidth}{0.4pt}%
  \if@twoside%
    \fancyhead[LE]{\small\sl\leftmark}%
    \fancyhead[RO]{\small\sl\rightmark}%
  \else%
    \fancyhead[L]{\small\sl\leftmark}%
    \fancyhead[R]{\small\sl\rightmark}%
  \fi%
  \fancyfoot{}%
  \renewcommand{\footrulewidth}{0.4pt}%
  \if@twoside%
    \fancyfoot[LE,RO]{\thepage}%
    \fancyfoot[RE]{\footnotesize\MakeUppercase\@title}%
    \fancyfoot[LO]{\footnotesize{\@organizationInfo}}%
  \else%
    \fancyfoot[L]{\footnotesize{\@organizationInfo}}%
    \fancyfoot[R]{\thepage}%
  \fi%
}

% Zmiana znaczenia maketitle
\renewcommand{\maketitle}{%
  \begin{titlepage}%
    \null
    \hfill\@logo
    \vfill
    \noindent\hfill{\LARGE \textbf\textsc\textsf{\@title}\par}%
    \vskip 2mm%
    \hrule%
    \vskip 2mm%
    \noindent\hfill{\large \textbf\textsl\textsf{\@subtitle}\par}%
    \vskip 1cm%
    \begin{center}
    \noindent\begin{tabularx}{0.95\textwidth}{lX}
      Autor: & \@author \\
      Data ostatniej zmiany: & \@date \\
      Abstrakt: & 
      \@info
    \end{tabularx}
    \end{center}
    \vskip 60\p@
%    \null
  \end{titlepage}%
}

% Inna prezentacja tytuw rozdziaw
\def\@makechapterhead#1{%
  \vspace*{50\p@}%
  {\parindent \z@ \raggedright \normalfont
    \Huge\bfseries\sffamily
    \ifnum \c@secnumdepth >\m@ne
        \thechapter.\,%
        \fi
    \interlinepenalty\@M
    #1\par\nobreak
    \rule[15pt]{\textwidth}{1pt}
    \vskip 40\p@
  }}
\def\@makeschapterhead#1{%
  \vspace*{50\p@}%
  {\parindent \z@ \raggedright \normalfont
    \Huge\bfseries\sffamily
    \interlinepenalty\@M
    #1\par\nobreak
    \vskip 40\p@
  }}

\renewcommand{\@seccntformat}[1]{\sffamily\csname the#1\endcsname.\,}

\renewcommand\section{\@startsection {section}{1}{\z@}%
                                   {-3.5ex \@plus -1ex \@minus -.2ex}%
                                   {2.3ex \@plus.2ex}%
                                   {\normalfont\Large\bfseries\sffamily}}
\renewcommand\subsection{\@startsection{subsection}{2}{\z@}%
                                     {-3.25ex\@plus -1ex \@minus -.2ex}%
                                     {1.5ex \@plus .2ex}%
                                     {\normalfont\large\bfseries\sffamily}}
\renewcommand\subsubsection{\@startsection{subsubsection}{3}{\z@}%
                                     {-3.25ex\@plus -1ex \@minus -.2ex}%
                                     {1.5ex \@plus .2ex}%
                                     {\normalfont\normalsize\bfseries\sffamily}}


\newcommand{\@restrictions}{%
  \ClassWarning{mkofficial}{Brak \noexpand\restrictions}%
  \fbox{Tu by niele wyglday zastrzeenia dotyczce treci dokumentu.}%
}
\DeclareRobustCommand{\restrictions}[1]{%
  \renewcommand{\@restrictions}{#1}%
}

% Informacje o dokumencie
\newcommand{\colophon}{
  \thispagestyle{empty}
  \subsubsection*{Podstawowe informacje o dokumencie}
  \renewcommand{\arraystretch}{1.1}
  \begin{tabularx}{\textwidth}{|lX|}
    \hhline{--}
    \textsf{Autor:} & \textsf{\@author} \\
    \textsf{Status:} & \textsf{\@status} \\
    \hhline{--}
    \textsf{Tytu:} & \textsf{\@title} \\
    \textsf{Podtytu:} & \textsf{\@subtitle} \\
    \textsf{Projekt:} & \textsf{\@project} \\
    \textsf{Utworzenie:} & \textsf{\@creationDate\ roku} \\
    \textsf{Ostatnie zmiany:} & \textsf{\@date} \\
    \textsf{Wersja:} & \textsf{\RCSRevision} \\
%    \textsf{Plik rdowy:} & \texttt{\small\RCSSource} \\
    \textsf{Plik rdowy:} & \texttt{\RCSRCSFile} \\
    \hhline{--}
  \end{tabularx}%
  \renewcommand{\arraystretch}{1}%
  \subsubsection*{Zastrzeenia}
  \@restrictions
  }

\AtBeginDocument{%
  \maketitle
  \colophon
  \setcounter{page}{0}
  \pagestyle{thebody}
  \tableofcontents
}
%\AtEndDocument

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% ToDo
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Komentarz o rzeczy do napisania - dugi
\newsavebox{\ToDoBox}
\newenvironment{ToDoEnv}
  {\begin{lrbox}{\ToDoBox}\itshape\begin{minipage}{.8\textwidth}\textbf{Do uzupenienia:}\par}
  {\end{minipage}\end{lrbox}
   \rightarrowfill\fbox{\usebox{\ToDoBox}}}

% Komentarz o rzeczy do napisania - krcej
\newcommand{\ToDo}[1]
  {\par\begin{ToDoEnv}#1\end{ToDoEnv}\par}

% Ponisze wycza ToDo
%\renewcommand{\ToDo}[1]{}


% Local Variables:
% TeX-master: "przyklad.tex"
% End:
